
const bycrypt = require("bcrypt");

const saltRounds = 12;

const hasPassword = (password) =>  {

    return bycrypt.hash(password , saltRounds);

}



const comparePassword = (plainPassword, hashedPassword) => {
    return bycrypt.compare(plainPassword , hashedPassword);
}



module.exports = {
    hashPassword  : hasPassword,
    comparePassword : comparePassword
};