const { eq, and } = require("drizzle-orm");
const { db } = require("../db");
const { users } = require("../db/schemas/userSchema");
const { comparePassword } = require("../utils/passwordUtils");
const { roles } = require("../db/schemas/roleSchema");

const loginService = async (body) => {
  try {
    const { email, password } = body;

    // console.log("🚀 ~ loginService ~ body:", password)

    if (email === "" || password === "") {
      return { success: false, message: "Email and password are required" };
    }

    const user = await db
      .select()
      .from(users)
      .where(and(eq(users.email, email) , eq(users.isActive , true)))
      .limit(1);

    if (user.length === 0) {
      return { success: false, message: "Invalid email or password or user is inActive" };
    }

    // compare passwords (in a real application, use hashed passwords)


    const resultPass = await comparePassword(password, user[0].password);
    console.log("🚀 ~ loginService ~ resultPass:", resultPass)

    if (resultPass === false) {

      return { success: false, message: "Invalid email or password" };
    }

    const {password: pwd, ...userWithoutPassword} = user[0];

    // console.log("🚀 ~ loginService ~ userWithoutPassword:", userWithoutPassword)

    // now fetch the role details and attach to user object
    const role = await db.select().from(roles).where(eq(roles.id, user[0].role)).limit(1);
    console.log("🚀 ~ loginService ~ role:", role)
    if(role.length > 0) {
      userWithoutPassword.roleDetails = role[0];
    }

    return {
      success: true,
      message: "Login successful",
      data: { userWithoutPassword },
    };

  } catch (e) {
    return { success: false, message: e.message };
  }
};





module.exports = {
    loginService,
}