const express = require("express");
const router  = express.Router();


/**
 * @swagger
 * /sampleRoutes/test/resource/{id}:
 *   get:
 *     summary: Get a resource
 *     description: Get a specific resource by ID.
 *     tags:
 *       - Sample Routes
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         description: ID of the resource to retrieve.
 *         schema:
 *           type: string
 *     responses:
 *       200:
 *         description: Successful response
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 */

router.get("/test/resource/:id", (req, res) => {
  // Your route logic goes here
  res.json({ message: `Resource with ID: ${req.params.id}` });
});




module.exports = router;
