const express = require("express");

const {
  getNotificationsController,
  getUnreadNotificationsCountController,
  markNotificationReadController,
  markNotificationUnreadController,
  markAllNotificationsReadController,
  deleteNotificationController,
} = require("../controllers/notificationsControllers");

const router = express.Router();

router.get("/", getNotificationsController);
router.get("/unread-count", getUnreadNotificationsCountController);

router.post("/read-all", markAllNotificationsReadController);
router.post("/:id/read", markNotificationReadController);
router.post("/:id/unread", markNotificationUnreadController);

router.delete("/:id", deleteNotificationController);

module.exports = router;
