const express = require("express");

const {
  getAllForm297TicketsController,
  getForm297TicketByIdController,
  createForm297TicketController,
  updateForm297TicketController,
  submitForm297TicketController,
  deleteForm297TicketController,
  completeForm297TicketController,
  getForm297TicketsByAgreementAndDateRangeController,
} = require("../controllers/form297Controllers");

const router = express.Router();

router.get("/", getAllForm297TicketsController);
router.get("/search/by-agreement-date", getForm297TicketsByAgreementAndDateRangeController);
router.get("/:id", getForm297TicketByIdController);

router.post("/", createForm297TicketController);
router.put("/", updateForm297TicketController);

router.post("/:id/submit", submitForm297TicketController);
router.post("/:id/complete" , completeForm297TicketController);
// router.post("/:id/supervisor-sign", supervisorSignForm297TicketController);

router.delete("/:id", deleteForm297TicketController);

module.exports = router;
