const express = require("express");

const {
  getAllForm288ReportsController,
  getForm288ReportByIdController,
  createForm288ReportController,
  updateForm288ReportController,
  submitForm288ReportController,
  completeForm288ReportController,
  deleteForm288ReportController,
} = require("../controllers/form288Controllers");

const router = express.Router();

router.get("/", getAllForm288ReportsController);
router.get("/:id", getForm288ReportByIdController);

router.post("/", createForm288ReportController);
router.put("/", updateForm288ReportController);

router.post("/:id/submit", submitForm288ReportController);
router.post("/:id/complete", completeForm288ReportController);

router.delete("/:id", deleteForm288ReportController);

module.exports = router;
