const express = require("express");

const {
  getAllForm268ReportsController,
  getForm268ReportByIdController,
  createForm268ReportController,
  updateForm268ReportController,
  submitForm268ReportController,
  completeForm268ReportController,
  deleteForm268ReportController,
} = require("../controllers/form268Controllers");

const router = express.Router();

router.get("/", getAllForm268ReportsController);
router.get("/:id", getForm268ReportByIdController);

router.post("/", createForm268ReportController);
router.put("/", updateForm268ReportController);

router.post("/:id/submit", submitForm268ReportController);
router.post("/:id/complete", completeForm268ReportController);

router.delete("/:id", deleteForm268ReportController);

module.exports = router;
