const express = require("express");

const {
  getAllForm261ReportsController,
  getForm261ReportByIdController,
  createForm261ReportController,
  updateForm261ReportController,
  submitForm261ReportController,
  deleteForm261ReportController,
  completeForm261ReportController,
  getForm261TicketsByCrewNumberAndDateRangeController,
} = require("../controllers/form261Controllers");

const router = express.Router();

router.get("/", getAllForm261ReportsController);
router.get("/:id", getForm261ReportByIdController);

router.post("/", createForm261ReportController);
router.put("/", updateForm261ReportController);

router.post("/:id/submit", submitForm261ReportController);
router.post("/:id/complete", completeForm261ReportController);

router.delete("/:id", deleteForm261ReportController);
router.post('/getReportFromDateRange' , getForm261TicketsByCrewNumberAndDateRangeController)

module.exports = router;
