const { httpStatus } = require("../utils/responseHandler");
const jwt = require("jsonwebtoken");

  const allowedRoles = ["admin", "superadmin"];

 

const authentication = async (req, res, next) =>  {
    // console.log(req.cookies.authToken);
    const token = req.cookies.authToken;
    // console.log("Authentication Middleware: Token from cookies:", token);

    if (!token) {
        return res.status(httpStatus.UNAUTHORIZED).json({ message: "Unauthorized: No token provided" });
    }

    try {
        const payload =  jwt.verify(token , process.env.JWT_SECRET);
        req.user = payload.user; // Attach user info to request object
        const isAdmin = checkAdminPreviliges(req.user);
        req.user.isAdmin = isAdmin;
        next();
    } catch (err) {
        return res.status(httpStatus.UNAUTHORIZED).json({ message: "Unauthorized: Invalid token" });
    }   
}


const checkAdminPreviliges = (user) => {
    const isAdmin = allowedRoles.includes(
      user?.roleDetails?.name?.toLowerCase()
    );
    // console.log("middleware:", isAdmin);
    return isAdmin;
}

module.exports = {
    authentication,
    checkAdminPreviliges    
};    
