const cookieParser = require("cookie-parser");
const express = require("express");

const app = express();

// route imports
const sampleRoutes = require("./routes/sampleRoutes.js");
const authRoutes = require("./routes/authRoutes.js");
const userRoutes = require("./routes/userRoutes.js");
const roleRoutes = require("./routes/roleRoutes.js");
const form297Routes = require("./routes/form297Routes.js");
const form261Routes = require("./routes/form261Routes.js");
const form288Routes = require("./routes/form288Routes.js");
const form268Routes = require("./routes/form268Routes.js");
const allFormsRoutes = require("./routes/allFormsRoutes.js");
const notificationsRoutes = require("./routes/notificationsRoutes.js");

// swagger setup
const swaggerUI = require("swagger-ui-express");
const swaggerSpec = require("../swagger");

// Serve Swagger documentation
app.use("/api-docs", swaggerUI.serve, swaggerUI.setup(swaggerSpec));

const cors = require("cors");
const { authentication } = require("./middleware/authentication.js");

// When deployed behind IIS / reverse proxies, this helps Express correctly detect HTTPS.
app.set("trust proxy", 1);

const getAllowedOrigins = () => {
  const raw = process.env.CORS_ORIGINS || process.env.FRONTEND_ORIGIN || "http://localhost:3000";
  return String(raw)
    .split(",")
    .map((s) => s.trim())
    .filter(Boolean);
};

const corsOptions = {
  origin: (origin, cb) => {
    const isProd = process.env.NODE_ENV === "production";
    if (!isProd) {
      // Dev: allow any origin so local environments don't break.
      return cb(null, true);
    }
    const allowed = getAllowedOrigins();
    // allow server-to-server or tools with no Origin header
    if (!origin) return cb(null, true);
    if (allowed.includes(origin)) return cb(null, true);
    return cb(new Error(`CORS blocked for origin: ${origin}`));
  },
  credentials: true,
};

app.use(
  cors(corsOptions)
);

// Preflight: use a RegExp because some router versions crash on "*"
app.options(/.*/, cors(corsOptions));

app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(cookieParser());

app.get("/", (req, res) => {
  res.send("hello world!, The Sand Hollow server is up and running");
});

app.use("/api/auth", authRoutes);

// app.use(authentication);
app.use('/api/user' , authentication , userRoutes);
app.use('/api/role' , authentication ,roleRoutes);
app.use('/api/form297' , authentication , form297Routes);
app.use('/api/form261' , authentication , form261Routes);
app.use('/api/form288' , authentication , form288Routes);
app.use('/api/form268' , authentication , form268Routes);
app.use('/api/all-forms' , authentication , allFormsRoutes);
app.use('/api/notifications' , authentication , notificationsRoutes);

app.use("/sampleRoutes", sampleRoutes);
// app.use("/api/auth", authRoutes);





module.exports = app;
