const { ForeignKey } = require("drizzle-orm/mysql-core");
const { int, mysqlTable, serial, varchar } = require("drizzle-orm/mysql-core");
const { roles } = require("./roleSchema");
const { bigint } = require("drizzle-orm/mysql-core");
const { commonFileds } = require("../commonFields");
const { boolean } = require("drizzle-orm/mysql-core");

const users = mysqlTable("user", {
  id: int("id").primaryKey().autoincrement(),
  name: varchar("name", { length: 255 }).notNull(),
  phone: varchar("phone", { length: 20 }).notNull().unique(),
  email: varchar("email", { length: 255 }).notNull().unique(),
  password: varchar("password", { length: 255 }).notNull(),
  role: int("role_id").references(() => roles.id, { onDelete: "set null" }),
  isActive: boolean('is_active').notNull().default(false),
  ...commonFileds,
});

module.exports = {
  users,
};
