const {
  mysqlTable,
  int,
  varchar,
  text,
  timestamp,
  mysqlEnum,
  json,
} = require("drizzle-orm/mysql-core");

const { users } = require("./userSchema");
const { commonFileds } = require("../commonFields");

const notifications = mysqlTable("notifications", {
  id: int("id").primaryKey().autoincrement(),

  entityType: varchar("entity_type", { length: 100 }).notNull(),
  entityId: varchar("entity_id", { length: 64 }).notNull(),
  type: varchar("type", { length: 100 }).notNull(),

  recipientId: int("recipient_id")
    .notNull()
    .references(() => users.id, { onDelete: "cascade" }),

  senderId: int("sender_id").references(() => users.id, { onDelete: "set null" }),

  title: varchar("title", { length: 255 }),
  message: text("message"),
  payload: json("payload"),

  status: mysqlEnum("status", ["pending", "sent", "failed"]).notNull().default("pending"),
  readAt: timestamp("read_at"),

  ...commonFileds,
});

module.exports = {
  notifications,
};
