const {
  mysqlTable,
  int,
  varchar,
  boolean,
  date,
  time,
  timestamp,
  decimal,
  mysqlEnum,
  text,
} = require("drizzle-orm/mysql-core");

const { commonFileds } = require("../commonFields");
const { users } = require("./userSchema");
const { allForms } = require("./allForms");
const { mediumtext } = require("drizzle-orm/mysql-core");
const { index } = require("drizzle-orm/mysql-core");

const form297Tickets = mysqlTable("form297_ticket", {
  id: int("id").primaryKey().autoincrement(),

  formId: int("form_id").references(() => allForms.id, {
    onDelete: "cascade",
    onUpdate: "no action",
  }),

  agreementNumber: varchar("agreement_number", { length: 255 }).notNull(),
  contractorAgencyName: varchar("contractor_agency_name", {
    length: 255,
  }).notNull(),
  resourceOrderNumber: varchar("resource_order_number", {
    length: 255,
  }).notNull(),

  incidentName: varchar("incident_name", { length: 255 }).notNull(),
  incidentNumber: varchar("incident_number", { length: 255 }).notNull(),
  financialCode: varchar("financial_code", { length: 255 }).notNull(),

  equipmentMakeModel: varchar("equipment_make_model", { length: 255 }),
  equipmentType: varchar("equipment_type", { length: 255 }),
  serialVinNumber: varchar("serial_vin_number", { length: 255 }),
  licenseIdNumber: varchar("license_id_number", { length: 255 }),

  transportRetained: mysqlEnum("transport_retained", ["yes", "no", "na"])
    .notNull()
    .default("na"),

  isFirstLastTicket: boolean("is_first_last_ticket").notNull().default(false),
  mobilization: boolean("mobilization").notNull().default(false),
  demobilization: boolean("demobilization").notNull().default(false),

  unitType: mysqlEnum("unit_type", ["miles", "hours"])
    .notNull()
    .default("hours"),

  remarks: text("remarks"),

  contractorRepPrintedName: varchar("contractor_rep_printed_name", {
    length: 255,
  }),
  incidentSupervisorPosition : varchar("incident_supervisor_position" , {
    length : 255
  }),
  contractorRepSignature: mediumtext("contractor_rep_signature"),
  incidentSupervisorPrintedName: varchar("incident_supervisor_printed_name", {
    length: 255,
  }),
  incidentSupervisorResourceOrderNumber: varchar(
    "incident_supervisor_resource_order_number",
    {
      length: 255,
    },
  ),
  incidentSupervisorSignature: mediumtext("incident_supervisor_signature"),

  status: mysqlEnum("status", [
    "draft",
    "submitted",
    "completed",
  ])
    .notNull()
    .default("draft"),

  submittedAt: timestamp("submitted_at"),
  contractorSignedAt: timestamp("contractor_signed_at"),
  completedAt: timestamp("completed_at"),

  createdBy: int("created_by").references(() => users.id, {
    onDelete: "set null",
  }),
  updatedBy: int("updated_by").references(() => users.id, {
    onDelete: "set null",
  }),


  ...commonFileds,
},
  (table) => ({
    agreementNumberIndex: index("idx_agreement_number").on(table.agreementNumber),
  })
);

const form297EquipmentEntries = mysqlTable("form297_equipment_entry", {
  id: int("id").primaryKey().autoincrement(),
  ticketId: int("ticket_id")
    .notNull()
    .references(() => form297Tickets.id, { onDelete: "cascade" }),

  workDate: date("work_date").notNull(),

  startTime: time("start_time"),
  stopTime: time("stop_time"),
  startOdometer: decimal("start_odometer", { precision: 10, scale: 2 }),
  stopOdometer: decimal("stop_odometer", { precision: 10, scale: 2 }),

  total: decimal("total", { precision: 10, scale: 2 }),

  quantity: decimal("quantity", { precision: 10, scale: 2 }),
  type: varchar("type", { length: 255 }),
  note: varchar("note", { length: 1000 }),

  ...commonFileds,
});

const form297PersonnelEntries = mysqlTable("form297_personnel_entry", {
  id: int("id").primaryKey().autoincrement(),
  ticketId: int("ticket_id")
    .notNull()
    .references(() => form297Tickets.id, { onDelete: "cascade" }),

  workDate: date("work_date").notNull(),
  operatorName: varchar("operator_name", { length: 255 }),
  operatorUserId: int("operator_user_id").references(() => users.id, {
    onDelete: "set null",
  }),

  startTime1: time("start_time_1"),
  stopTime1: time("stop_time_1"),
  startTime2: time("start_time_2"),
  stopTime2: time("stop_time_2"),

  total: decimal("total", { precision: 10, scale: 2 }),
  note: varchar("note", { length: 1000 }),

  ...commonFileds,
});

module.exports = {
  form297Tickets,
  form297EquipmentEntries,
  form297PersonnelEntries,
};
