const {
  mysqlTable,
  int,
  varchar,
  date,
  time,
  decimal,
  timestamp,
  mysqlEnum,
} = require("drizzle-orm/mysql-core");

const { mediumtext } = require("drizzle-orm/mysql-core");

const { commonFileds } = require("../commonFields");
const { users } = require("./userSchema");
const { allForms } = require("./allForms");

const form288Reports = mysqlTable("form288_report", {
  id: int("id").primaryKey().autoincrement(),

  formId: int("form_id").references(() => allForms.id, {
    onDelete: "cascade",
    onUpdate: "no action",
  }),

  hiredAt: varchar("hired_at", { length: 255 }),
  employeeCommonIdentifier: varchar("employee_common_identifier", { length: 255 }),
  typeOfEmployment: varchar("type_of_employment", { length: 255 }),
  hiringUnitName: varchar("hiring_unit_name", { length: 255 }),

  hiringUnitPhoneNumber: varchar("hiring_unit_phone_number", { length: 255 }),
  hiringUnitFaxNumber: varchar("hiring_unit_fax_number", { length: 255 }),

  incidentName: varchar("incident_name", { length: 255 }),
  incidentOrderNumber: varchar("incident_order_number", { length: 255 }),
  fireCode: varchar("fire_code", { length: 255 }),
  resourceRequestNumber: varchar("resource_request_number", { length: 255 }),

  remarks: varchar("remarks", { length: 4000 }),

  employeeSignature: mediumtext("employee_signature"),
  timeOfficerSignature: mediumtext("time_officer_signature"),

  status: mysqlEnum("status", ["draft", "submitted", "completed"])
    .notNull()
    .default("draft"),

  submittedAt: timestamp("submitted_at"),
  completedAt: timestamp("completed_at"),

  createdBy: int("created_by").references(() => users.id, {
    onDelete: "set null",
  }),
  updatedBy: int("updated_by").references(() => users.id, {
    onDelete: "set null",
  }),

  ...commonFileds,
});

const form288Employees = mysqlTable("form288_employee", {
  id: int("id").primaryKey().autoincrement(),

  reportId: int("report_id")
    .notNull()
    .references(() => form288Reports.id, { onDelete: "cascade" }),

  employeeName: varchar("employee_name", { length: 255 }),
  employeeUserId: int("employee_user_id").references(() => users.id, {
    onDelete: "set null",
  }),

  name: varchar("name", { length: 255 }),
  positionCode: varchar("position_code", { length: 255 }),

  adClass: varchar("ad_class", { length: 255 }),
  adRate: varchar("ad_rate", { length: 255 }),
  homeHiringUnitAccountingCode: varchar("home_hiring_unit_accounting_code", { length: 255 }),

  ...commonFileds,
});

const form288CommissaryEntries = mysqlTable("form288_commissary_entry", {
  id: int("id").primaryKey().autoincrement(),

  reportId: int("report_id")
    .notNull()
    .references(() => form288Reports.id, { onDelete: "cascade" }),

  month: varchar("month", { length: 25 }),
  day: varchar("day", { length: 25 }),
  category: varchar("category", { length: 255 }),
  reimbursement: decimal("reimbursement", { precision: 10, scale: 2 }),
  deduction: decimal("deduction", { precision: 10, scale: 2 }),
  fireCode: varchar("fire_code", { length: 255 }),

  ...commonFileds,
});

const form288TimeEntries = mysqlTable("form288_time_entry", {
  id: int("id").primaryKey().autoincrement(),

  employeeId: int("employee_id")
    .notNull()
    .references(() => form288Employees.id, { onDelete: "cascade" }),

  workDate: date("work_date").notNull(),

  startTime: time("start_time"),
  stopTime: time("stop_time"),

  hours: decimal("hours", { precision: 10, scale: 2 }),

  rowIndex: int("row_index").notNull().default(0),

  ...commonFileds,
});

module.exports = {
  form288Reports,
  form288Employees,
  form288CommissaryEntries,
  form288TimeEntries,
};
