const {
  mysqlTable,
  int,
  varchar,
  date,
  time,
  decimal,
  timestamp,
  mysqlEnum,
  text,
} = require("drizzle-orm/mysql-core");

const { mediumtext } = require("drizzle-orm/mysql-core");

const { commonFileds } = require("../commonFields");
const { users } = require("./userSchema");
const { allForms } = require("./allForms");

const form268Reports = mysqlTable("form268_report", {
  id: int("id").primaryKey().autoincrement(),

  formId: int("form_id").references(() => allForms.id, {
    onDelete: "cascade",
    onUpdate: "no action",
  }),

  // Box 1: Contractor name and address
  contractorName: varchar("contractor_name", { length: 500 }),
  contractorAddress: varchar("contractor_address", { length: 500 }),

  // Box 2: Incident or Project Name
  incidentName: varchar("incident_name", { length: 255 }),

  // Box 3: Agreement Number (from OF-294)
  agreementNumber: varchar("agreement_number", { length: 255 }),

  // Box 4: Effective Dates of Agreement
  agreementBeginDate: date("agreement_begin_date"),
  agreementEndDate: date("agreement_end_date"),

  // Box 5: Equipment (make, model, serial number, etc.)
  equipmentMake: varchar("equipment_make", { length: 255 }),
  equipmentModel: varchar("equipment_model", { length: 255 }),
  equipmentSerialNumber: varchar("equipment_serial_number", { length: 255 }),
  equipmentDescription: text("equipment_description"),

  // Box 6: Point of Hire (location when hired)
  pointOfHire: varchar("point_of_hire", { length: 500 }),

  // Box 7: Date of Hire
  dateOfHire: date("date_of_hire"),

  // Box 8: Time of Hire
  timeOfHire: time("time_of_hire"),

  // Box 9: Administrative Office for Payment
  adminOfficeForPayment: varchar("admin_office_for_payment", { length: 500 }),

  // Box 10: Work Rate Based on Operating Supplies Furnished By
  operatingSuppliesBy: mysqlEnum("operating_supplies_by", ["contractor", "government"]),

  // Box 11: Operator Furnished By
  operatorFurnishedBy: mysqlEnum("operator_furnished_by", ["contractor", "government"]),

  // Box 12: Resource Order Number
  resourceOrderNumber: varchar("resource_order_number", { length: 255 }),

  // Box 17: Guarantee
  guaranteeAmount: decimal("guarantee_amount", { precision: 12, scale: 2 }),

  // Box 19: Charge Code
  chargeCode: varchar("charge_code", { length: 255 }),

  // Box 20: Object Code
  objectCode: varchar("object_code", { length: 255 }),

  // Box 21: Equipment Released/Withdrawn
  equipmentReleased: mysqlEnum("equipment_released", ["released", "withdrawn"]),
  equipmentReleasedDate: date("equipment_released_date"),
  equipmentReleasedTime: time("equipment_released_time"),

  // Box 22: Remarks
  remarks: text("remarks"),

  // Financial Summary (Boxes 16, 18, 23-28)
  totalAmountEarned: decimal("total_amount_earned", { precision: 12, scale: 2 }),
  amountDue: decimal("amount_due", { precision: 12, scale: 2 }),
  grossAmountDue: decimal("gross_amount_due", { precision: 12, scale: 2 }),
  previousPageAmount: decimal("previous_page_amount", { precision: 12, scale: 2 }),
  totalAmountDue: decimal("total_amount_due", { precision: 12, scale: 2 }),
  deductions: decimal("deductions", { precision: 12, scale: 2 }),
  additions: decimal("additions", { precision: 12, scale: 2 }),
  gratuity: decimal("gratuity", { precision: 12, scale: 2 }),
  netAmountDue: decimal("net_amount_due", { precision: 12, scale: 2 }),

  // Box 30: Contractor's Signature
  contractorSignature: mediumtext("contractor_signature"),

  // Box 31: Contractor Date
  contractorSignatureDate: date("contractor_signature_date"),

  // Box 32: Receiving Officer's Signature
  receivingOfficerSignature: mediumtext("receiving_officer_signature"),

  // Box 33: Receiving Officer Date
  receivingOfficerDate: date("receiving_officer_date"),

  // Box 34: Contractor Print Name and Title
  contractorPrintName: varchar("contractor_print_name", { length: 255 }),
  contractorTitle: varchar("contractor_title", { length: 255 }),

  // Box 35: Receiving Officer Print Name and Title
  receivingOfficerPrintName: varchar("receiving_officer_print_name", { length: 255 }),
  receivingOfficerTitle: varchar("receiving_officer_title", { length: 255 }),

  status: mysqlEnum("status", ["draft", "submitted", "completed"])
    .notNull()
    .default("draft"),

  submittedAt: timestamp("submitted_at"),
  completedAt: timestamp("completed_at"),

  createdBy: int("created_by").references(() => users.id, {
    onDelete: "set null",
  }),
  updatedBy: int("updated_by").references(() => users.id, {
    onDelete: "set null",
  }),

  ...commonFileds,
});

// Table for rate entries (Boxes 13-16, 18 work/daily rate and special rate entries)
const form268RateEntries = mysqlTable("form268_rate_entry", {
  id: int("id").primaryKey().autoincrement(),

  reportId: int("report_id")
    .notNull()
    .references(() => form268Reports.id, { onDelete: "cascade" }),

  // Box 13: Year/Month/Day
  entryYear: varchar("entry_year", { length: 4 }),
  entryMonth: varchar("entry_month", { length: 2 }),
  entryDay: varchar("entry_day", { length: 2 }),

  // Box 14: Work or Daily Rate
  workUnits: varchar("work_units", { length: 255 }),
  workRate: varchar("work_rate", { length: 255 }),
  workAmount: varchar("work_amount", { length: 255 }),

  // Box 15: Special Rate
  specialUnits: varchar("special_units", { length: 255 }),
  specialRate: varchar("special_rate", { length: 255 }),
  specialAmount: varchar("special_amount", { length: 255 }),

  // Boxes 16-18 (row-level)
  totalAmountEarned: varchar("total_amount_earned", { length: 255 }),
  guaranteeAmount: varchar("guarantee_amount", { length: 255 }),
  amount: varchar("amount", { length: 255 }),

  rowIndex: int("row_index").notNull().default(0),

  ...commonFileds,
});

module.exports = {
  form268Reports,
  form268RateEntries,
};
