const {
  mysqlTable,
  int,
  varchar,
  date,
  time,
  timestamp,
  mysqlEnum,
} = require("drizzle-orm/mysql-core");

const { mediumtext } = require("drizzle-orm/mysql-core");

const { commonFileds } = require("../commonFields");
const { users } = require("./userSchema");
const { allForms } = require("./allForms");
const { form297Tickets } = require("./form297Schema");

const form261Reports = mysqlTable("form261_report", {
  id: int("id").primaryKey().autoincrement(),

  formId: int("form_id").references(() => allForms.id, {
    onDelete: "cascade",
    onUpdate: "no action",
  }),

  form297Id : int("form297Id").references(()=>form297Tickets.id ,{
        onDelete: "cascade",
    onUpdate: "no action",
  })
,
  crewName: varchar("crew_name", { length: 255 }).notNull(),
  crewNumber: varchar("crew_number", { length: 255 }).notNull(),

  officeResponsibleForFire: varchar("office_responsible_for_fire", {
    length: 255,
  }).notNull(),
  fireName: varchar("fire_name", { length: 255 }).notNull(),
  fireNumber: varchar("fire_number", { length: 255 }).notNull(),

  day1Date: date("day_1_date"),
  day2Date: date("day_2_date"),
  day3Date: date("day_3_date"),
  day4Date: date("day_4_date"),
  day5Date: date("day_5_date"),

  remarks: varchar("remarks", { length: 4000 }),

  officerInChargeSignature: mediumtext("officer_in_charge_signature"),
  officerInChargeTitle: varchar("officer_in_charge_title", { length: 255 }),

  postingPersonName: varchar("posting_person_name", { length: 255 }),
  postingPersonSignature: mediumtext("posting_person_signature"),
  postingDate: date("posting_date"),

  additionalSignerName: varchar("additional_signer_name", { length: 255 }),
  additionalSignerTitle: varchar("additional_signer_title", { length: 255 }),
  additionalSignerSignature: mediumtext("additional_signer_signature"),

  status: mysqlEnum("status", ["draft", "submitted", "completed"])
    .notNull()
    .default("draft"),

  submittedAt: timestamp("submitted_at"),
  completedAt: timestamp("completed_at"),

  createdBy: int("created_by").references(() => users.id, {
    onDelete: "set null",
  }),
  updatedBy: int("updated_by").references(() => users.id, {
    onDelete: "set null",
  }),

  ...commonFileds,
});

const form261TimeEntries = mysqlTable("form261_time_entry", {
  id: int("id").primaryKey().autoincrement(),

  reportId: int("report_id")
    .notNull()
    .references(() => form261Reports.id, { onDelete: "cascade" }),

  remarksNo: int("remarks_no"),

  employeeName: varchar("employee_name", { length: 255 }),
  employeeUserId: int("employee_user_id").references(() => users.id, {
    onDelete: "set null",
  }),
  classification: varchar("classification", { length: 255 }),

  rowIndex: int("row_index").notNull().default(0),
  dayIndex: int("day_index").notNull().default(1),

  onTime: time("on_time"),
  offTime: time("off_time"),

  ...commonFileds,
});

module.exports = {
  form261Reports,
  form261TimeEntries,
};
