const { saveUserService, updateUserService, deleteUserService, getAllUsersService, toggleIsActiveUserService } = require("../services/getAllUsersService");
const { httpStatus, responseTemplate } = require("../utils/responseHandler");

const getAllUsersController = async (req, res) => {
  try {
    const result = await getAllUsersService(req);
    // console.log("🚀 ~ getAllUsersController ~ result:", result)



    if (!result.success) {
      return res
        .status(httpStatus.OK)
        .json(responseTemplate.error("Could not fetch users", result.message));
    } else {
      return res
        .status(httpStatus.OK)
        .json(responseTemplate.success(result.data, result.message));
    }
  } catch (e) {
    res
      .status(httpStatus.INTERNAL_ERROR)
      .json(responseTemplate.error("Failed to fetch users", e.message));
  }
};

const saveUserController = async (req, res) => {
  const { name, email, phone, password, role , isActive} = req.body;


  if (!name || !email || !phone || !password) {
    return res
      .status(httpStatus.BAD_REQUEST)
      .json(responseTemplate.error("Missing required fields"));
  }

  //   role validation



  if (role && !Number.isInteger(role)) {
    return res
      .status(httpStatus.BAD_REQUEST)
      .json(responseTemplate.error("Role must be a valid role ID (number)"));
  }

  try {
    const result = await saveUserService({ name, email, phone, password, role ,isActive });
    console.log("🚀 ~ saveUserController ~ result:", result)

    if (!result.success) {
      return res
        .status(httpStatus.OK)
        .json(responseTemplate.error(result.message, result.data));
    } else {
      return res
        .status(httpStatus.OK)
        .json(responseTemplate.success(result.data, result.message));
    }
  } catch (e) {
    res
      .status(httpStatus.INTERNAL_ERROR)
      .json(responseTemplate.error("Failed to save user", e.message));
  }
};


const updateUserController = async (req, res) => {

  const { id } = req.body;
  if (!id || !Number.isInteger(id)) {
    return res.status(httpStatus.BAD_REQUEST).json(responseTemplate.error("Invalid or missing user ID"));
  }

  try {

    const result = await updateUserService(req.body);
    if (!result.success) {
      return res.status(httpStatus.BAD_REQUEST).json(responseTemplate.error(result.message, result.data));
    }
    else {
      return res.status(httpStatus.OK).json(responseTemplate.success(result.data, result.message));
    }

  }
  catch (e) {
    console.log("Error in updating user: ", e);
    return res.status(httpStatus.INTERNAL_ERROR).json(responseTemplate.error("Failed to update user", e.message))

  }
}

const deleteUserController = async (req, res) => {
  const { id: userId } = req.params;

  if (!userId || !Number.isInteger(parseInt(userId))) {
    return res.status(httpStatus.BAD_REQUEST).json(responseTemplate.error("Invalid or missing user ID"));
  }
  try {

    const result = await deleteUserService(parseInt(userId));
    if (!result.success) {
      return res.status(httpStatus.BAD_REQUEST).json(responseTemplate.error(result.message, result.data))
    }
    else {
      return res.status(httpStatus.OK).json(responseTemplate.success(result.data, result.message))
    }

  }
  catch (e) {
    return res.status(httpStatus.INTERNAL_ERROR).json(responseTemplate.error("Failed to delete user", e.message))
  }
}

const toggleIsActiveUser = async (req, res) => {
  try {
    const {id:userId} = req.params;
    const{status} = req.body;

    if (!userId || !Number.isInteger(parseInt(userId))) {
    return res.status(httpStatus.BAD_REQUEST).json(responseTemplate.error("Invalid or missing user ID"));
  }

    console.log('id' , id);

    const result = await toggleIsActiveUserService(id , status);

    if (!result.success) {
      return res.status(httpStatus.BAD_REQUEST).json(responseTemplate.error(result.message, result.data))
    }
    else {
      return res.status(httpStatus.OK).json(responseTemplate.success(result.data, result.message))
    }

  }
  catch (e) {
    return res.status(httpStatus.INTERNAL_ERROR).json(responseTemplate.error("Failed to update user", e.message))

  }
}

module.exports = {
  getAllUsersController,
  saveUserController,
  updateUserController,
  deleteUserController,
  toggleIsActiveUser
};
