const { getAllRolesService, saveRoleService, updateRoleService, deleteRoleService } = require("../services/getAllRolesService");
const { httpStatus, responseTemplate } = require("../utils/responseHandler");

const getAllRolesController = async (req, res) => {
  try {
    const result = await getAllRolesService(req);

    if (!result.success) {
      return res
        .status(httpStatus.OK)
        .json(responseTemplate.error("Could not fetch roles", result.message));
    } else {
      return res
        .status(httpStatus.OK)
        .json(responseTemplate.success(result.data, result.message));
    }
  } catch (e) {
    res
      .status(httpStatus.INTERNAL_ERROR)
      .json(responseTemplate.error("Failed to fetch roles", e.message));
  }
};

const saveRoleController = async (req, res) => {
  const { name, description, isActive, isSuperAdmin } = req.body;

  if (!name) {
    return res
      .status(httpStatus.BAD_REQUEST)
      .json(responseTemplate.error("Missing required fields"));
  }

  try {
    const result = await saveRoleService({ name, description, isActive, isSuperAdmin });
    console.log("🚀 ~ saveRoleController ~ result:", result)

    if (!result.success) {
      return res
        .status(httpStatus.BAD_REQUEST)
        .json(responseTemplate.error(result.message, result.data));
    } else {
      return res
        .status(httpStatus.OK)
        .json(responseTemplate.success(result.data, result.message));
    }
  } catch (e) {
    res
      .status(httpStatus.INTERNAL_ERROR)
      .json(responseTemplate.error("Failed to save role", e.message));
  }
};

const updateRoleController = async (req, res) => {
    const {id} = req.body;
    if(!id || !Number.isInteger(id)) {
        return res.status(httpStatus.BAD_REQUEST).json(responseTemplate.error("Invalid or missing role ID"));
    }

    try{
        const result = await updateRoleService(req.body);
        if(!result.success) {
            return res.status(httpStatus.BAD_REQUEST).json(responseTemplate.error(result.message , result.data));
        }
        else {
            return res.status(httpStatus.OK).json(responseTemplate.success(result.data , result.message));
        }
    }
    catch(e)
    {
        console.log("Error in updating role: ", e);
        return res.status(httpStatus.INTERNAL_ERROR).json(responseTemplate.error("Failed to update role", e.message))
    }
}

const deleteRoleController = async ( req, res) =>  {
    const { id: roleId } = req.params;

    if(!roleId || !Number.isInteger(parseInt(roleId))) {
        return res.status(httpStatus.BAD_REQUEST).json(responseTemplate.error("Invalid or missing role ID"));
    }
    try{
        const result = await deleteRoleService( parseInt(roleId) );
        if(!result.success) {
            return res.status(httpStatus.BAD_REQUEST).json(responseTemplate.error(result.message , result.data))
        }
        else {
            return res.status(httpStatus.OK).json(responseTemplate.success(result.data , result.message))
        }
    }
    catch(e)
    {
        return res.status(httpStatus.INTERNAL_ERROR).json(responseTemplate.error("Failed to delete role", e.message))
    }
}

module.exports = {
  getAllRolesController,
  saveRoleController,
  updateRoleController,
  deleteRoleController
};