const { loginService } = require("../services/authServices");
const { httpStatus } = require("../utils/responseHandler")
const jwt = require("jsonwebtoken");

const loginController = async (req, res) => {

    try {

        const result = await loginService(req.body);

        if (result.success) {
            // if successful result then generate token and set cookie here
            const token = jwt.sign(
                { user: result.data.userWithoutPassword },
                process.env.JWT_SECRET,
                { expiresIn: "1d" }
            );


            res.cookie('authToken', token, {
                domain: process.env.COOKIE_DOMAIN || undefined,
                httpOnly: true,
                secure: (() => {
                    const isProd = process.env.NODE_ENV === "production";
                    const sameSite = String(process.env.COOKIE_SAMESITE || (isProd ? "none" : "lax")).toLowerCase();
                    // SameSite=None requires Secure in modern browsers
                    if (sameSite === "none") return true;
                    return isProd;
                })(),
                path: '/',
                maxAge: 24 * 60 * 60 * 1000, // 1 day
                sameSite: (() => {
                    const isProd = process.env.NODE_ENV === "production";
                    const v = String(process.env.COOKIE_SAMESITE || (isProd ? "none" : "lax")).toLowerCase();
                    return v === "strict" ? "strict" : v === "none" ? "none" : "lax";
                })(),
            });

            return res.status(httpStatus.OK).json(result);
        } else {
            return res.status(httpStatus.UNAUTHORIZED).json(result);
        }
    }
    catch (err) {
        res.status(httpStatus.INTERNAL_ERROR).json({ message: "Internal Server Error" });
    }
}



const registerController = async (req, res) => {
    try {

    }
    catch (err) {
        res.status(httpStatus.INTERNAL_ERROR).json({ message: "Internal Server Error" });
    }
}


const logoutController = async (req, res) => {
    console.log("logout")
    res.cookie('authToken', '', {
        domain: process.env.COOKIE_DOMAIN || undefined, // must match login
        httpOnly: true,
        secure: (() => {
            const isProd = process.env.NODE_ENV === "production";
            const sameSite = String(process.env.COOKIE_SAMESITE || (isProd ? "none" : "lax")).toLowerCase();
            // SameSite=None requires Secure in modern browsers
            if (sameSite === "none") return true;
            return isProd;
        })(),
        path: '/',                  // must match login
        maxAge: 0,                  // expires immediately
        sameSite: (() => {
            const isProd = process.env.NODE_ENV === "production";
            const v = String(process.env.COOKIE_SAMESITE || (isProd ? "none" : "lax")).toLowerCase();
            return v === "strict" ? "strict" : v === "none" ? "none" : "lax";
        })(),
    });
    console.log("succerss")
    res.status(httpStatus.OK).json({ message: "Loggedout successfully!" , success : true });
}


module.exports = {
    loginController,
    registerController,
    logoutController
}