const { getIO } = require("./socket.js");

function socketHandlers() {
  const io = getIO();

  io.on("connection", (socket) => {
    const userId = socket.user?.id;

    if (userId) {
      socket.join(`user:${userId}`); // user-specific room
    }
  });
}

module.exports = socketHandlers;
