const jwt = require("jsonwebtoken");

function socketAuth(io) {
  io.use((socket, next) => {
    try {
      const cookieHeader = socket.handshake.headers.cookie;

      const tokenFromCookie = cookieHeader
        ? cookieHeader
            .split(";")
            .map((p) => p.trim())
            .find((p) => p.startsWith("authToken="))
            ?.slice("authToken=".length)
        : null;

      const token = tokenFromCookie || socket.handshake.auth?.token;
      if (!token) return next(new Error("Unauthorized"));

      const decoded = jwt.verify(token, process.env.JWT_SECRET);

      // Our authControllers signs tokens as: { user: result.data.userWithoutPassword }
      socket.user = decoded?.user || decoded;

      next();
    } catch (err) {
      next(new Error("Unauthorized"));
    }
  });
}

module.exports = socketAuth;
