const express = require("express");
const http = require("http");
const { Server } = require("socket.io");
require("dotenv").config();

const app = require("./src/index");
const { db } = require("./src/db");
const { sql } = require("drizzle-orm");

const { setIO } = require("./src/Socket/socket.js");
const socketAuth = require("./src/Socket/socket.auth.js");
const socketHandlers = require("./src/Socket/socket.handler.js");


let io;

const getAllowedOrigins = () => {
  const raw = process.env.CORS_ORIGINS || process.env.FRONTEND_ORIGIN || "http://localhost:3000";
  return String(raw)
    .split(",")
    .map((s) => s.trim())
    .filter(Boolean);
};

async function startServer() {
  const httpServer = http.createServer(app);

  io = new Server(httpServer, {
    cors: {
      origin: getAllowedOrigins(),
      credentials: true,
    },
  });


  setIO(io);

  socketAuth(io);
  socketHandlers();

  io.on("connection", (socket) => {
    console.log("🟢 Socket connected:", socket.id);

    socket.on("disconnect", () => {
      console.log("🔴 Socket disconnected:", socket.id);
    });
  });

  try {
    await db.execute(sql`SELECT 1`);
    console.log("✅ Database connected successfully");

    httpServer.listen(process.env.Server_Port, () => {
      console.log(`🚀 Server running on port ${process.env.Server_Port}`);
    });
  } catch (error) {
    console.error("❌ Database connection failed");
    console.error(error);
    process.exit(1);
  }
}

startServer();