CREATE TABLE `all_forms` (
	`id` int AUTO_INCREMENT NOT NULL,
	`form_name` varchar(255) NOT NULL,
	`form_description` varchar(500),
	CONSTRAINT `all_forms_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form261_report` (
	`id` int AUTO_INCREMENT NOT NULL,
	`form_id` int,
	`crew_name` varchar(255) NOT NULL,
	`crew_number` varchar(255) NOT NULL,
	`office_responsible_for_fire` varchar(255) NOT NULL,
	`fire_name` varchar(255) NOT NULL,
	`fire_number` varchar(255) NOT NULL,
	`day_1_date` date,
	`day_2_date` date,
	`day_3_date` date,
	`day_4_date` date,
	`day_5_date` date,
	`remarks` varchar(4000),
	`officer_in_charge_signature` mediumtext,
	`officer_in_charge_title` varchar(255),
	`posting_person_name` varchar(255),
	`posting_person_signature` mediumtext,
	`posting_date` date,
	`additional_signer_name` varchar(255),
	`additional_signer_title` varchar(255),
	`additional_signer_signature` mediumtext,
	`status` enum('draft','submitted','completed') NOT NULL DEFAULT 'draft',
	`submitted_at` timestamp,
	`completed_at` timestamp,
	`created_by` int,
	`updated_by` int,
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form261_report_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form261_time_entry` (
	`id` int AUTO_INCREMENT NOT NULL,
	`report_id` int NOT NULL,
	`remarks_no` int,
	`employee_name` varchar(255),
	`employee_user_id` int,
	`classification` varchar(255),
	`row_index` int NOT NULL DEFAULT 0,
	`day_index` int NOT NULL DEFAULT 1,
	`on_time` time,
	`off_time` time,
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form261_time_entry_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form268_report` (
	`id` int AUTO_INCREMENT NOT NULL,
	`form_id` int,
	`contractor_name` varchar(500),
	`contractor_address` varchar(500),
	`incident_name` varchar(255),
	`agreement_number` varchar(255),
	`agreement_begin_date` date,
	`agreement_end_date` date,
	`equipment_make` varchar(255),
	`equipment_model` varchar(255),
	`equipment_serial_number` varchar(255),
	`equipment_description` text,
	`point_of_hire` varchar(500),
	`date_of_hire` date,
	`time_of_hire` time,
	`admin_office_for_payment` varchar(500),
	`operating_supplies_by` enum('contractor','government'),
	`operator_furnished_by` enum('contractor','government'),
	`resource_order_number` varchar(255),
	`guarantee_amount` decimal(12,2),
	`charge_code` varchar(255),
	`object_code` varchar(255),
	`equipment_released` enum('released','withdrawn'),
	`equipment_released_date` date,
	`equipment_released_time` time,
	`remarks` text,
	`total_amount_earned` decimal(12,2),
	`amount_due` decimal(12,2),
	`gross_amount_due` decimal(12,2),
	`previous_page_amount` decimal(12,2),
	`total_amount_due` decimal(12,2),
	`deductions` decimal(12,2),
	`additions` decimal(12,2),
	`gratuity` decimal(12,2),
	`net_amount_due` decimal(12,2),
	`contractor_signature` mediumtext,
	`contractor_signature_date` date,
	`receiving_officer_signature` mediumtext,
	`receiving_officer_date` date,
	`contractor_print_name` varchar(255),
	`contractor_title` varchar(255),
	`receiving_officer_print_name` varchar(255),
	`receiving_officer_title` varchar(255),
	`status` enum('draft','submitted','completed') NOT NULL DEFAULT 'draft',
	`submitted_at` timestamp,
	`completed_at` timestamp,
	`created_by` int,
	`updated_by` int,
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form268_report_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form268_rate_entry` (
	`id` int AUTO_INCREMENT NOT NULL,
	`report_id` int NOT NULL,
	`entry_year` varchar(4),
	`entry_month` varchar(2),
	`entry_day` varchar(2),
	`work_units` decimal(10,2),
	`work_rate` decimal(10,2),
	`work_amount` decimal(12,2),
	`special_units` decimal(10,2),
	`special_rate` decimal(10,2),
	`special_amount` decimal(12,2),
	`row_index` int NOT NULL DEFAULT 0,
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form268_rate_entry_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form288_report` (
	`id` int AUTO_INCREMENT NOT NULL,
	`form_id` int,
	`hired_at` varchar(255),
	`employee_common_identifier` varchar(255),
	`type_of_employment` varchar(255),
	`hiring_unit_name` varchar(255),
	`hiring_unit_phone_number` varchar(255),
	`hiring_unit_fax_number` varchar(255),
	`incident_name` varchar(255),
	`incident_order_number` varchar(255),
	`fire_code` varchar(255),
	`resource_request_number` varchar(255),
	`remarks` varchar(4000),
	`employee_signature` mediumtext,
	`time_officer_signature` mediumtext,
	`status` enum('draft','submitted','completed') NOT NULL DEFAULT 'draft',
	`submitted_at` timestamp,
	`completed_at` timestamp,
	`created_by` int,
	`updated_by` int,
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form288_report_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form288_employee` (
	`id` int AUTO_INCREMENT NOT NULL,
	`report_id` int NOT NULL,
	`employee_name` varchar(255),
	`employee_user_id` int,
	`name` varchar(255),
	`position_code` varchar(255),
	`ad_class` varchar(255),
	`ad_rate` varchar(255),
	`home_hiring_unit_accounting_code` varchar(255),
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form288_employee_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form288_commissary_entry` (
	`id` int AUTO_INCREMENT NOT NULL,
	`report_id` int NOT NULL,
	`month` varchar(25),
	`day` varchar(25),
	`category` varchar(255),
	`reimbursement` decimal(10,2),
	`deduction` decimal(10,2),
	`fire_code` varchar(255),
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form288_commissary_entry_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form288_time_entry` (
	`id` int AUTO_INCREMENT NOT NULL,
	`employee_id` int NOT NULL,
	`work_date` date NOT NULL,
	`start_time` time,
	`stop_time` time,
	`hours` decimal(10,2),
	`row_index` int NOT NULL DEFAULT 0,
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form288_time_entry_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form297_ticket` (
	`id` int AUTO_INCREMENT NOT NULL,
	`form_id` int,
	`agreement_number` varchar(255) NOT NULL,
	`contractor_agency_name` varchar(255) NOT NULL,
	`resource_order_number` varchar(255) NOT NULL,
	`incident_name` varchar(255) NOT NULL,
	`incident_number` varchar(255) NOT NULL,
	`financial_code` varchar(255) NOT NULL,
	`equipment_make_model` varchar(255),
	`equipment_type` varchar(255),
	`serial_vin_number` varchar(255),
	`license_id_number` varchar(255),
	`transport_retained` enum('yes','no','na') NOT NULL DEFAULT 'na',
	`is_first_last_ticket` boolean NOT NULL DEFAULT false,
	`mobilization` boolean NOT NULL DEFAULT false,
	`demobilization` boolean NOT NULL DEFAULT false,
	`unit_type` enum('miles','hours') NOT NULL DEFAULT 'hours',
	`remarks` text,
	`contractor_rep_printed_name` varchar(255),
	`contractor_rep_signature` mediumtext,
	`incident_supervisor_printed_name` varchar(255),
	`incident_supervisor_resource_order_number` varchar(255),
	`incident_supervisor_signature` mediumtext,
	`status` enum('draft','submitted','completed') NOT NULL DEFAULT 'draft',
	`submitted_at` timestamp,
	`contractor_signed_at` timestamp,
	`completed_at` timestamp,
	`created_by` int,
	`updated_by` int,
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form297_ticket_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form297_equipment_entry` (
	`id` int AUTO_INCREMENT NOT NULL,
	`ticket_id` int NOT NULL,
	`work_date` date NOT NULL,
	`start_time` time,
	`stop_time` time,
	`start_odometer` decimal(10,2),
	`stop_odometer` decimal(10,2),
	`total` decimal(10,2),
	`quantity` decimal(10,2),
	`type` varchar(255),
	`note` varchar(1000),
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form297_equipment_entry_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `form297_personnel_entry` (
	`id` int AUTO_INCREMENT NOT NULL,
	`ticket_id` int NOT NULL,
	`work_date` date NOT NULL,
	`operator_name` varchar(255),
	`operator_user_id` int,
	`start_time_1` time,
	`stop_time_1` time,
	`start_time_2` time,
	`stop_time_2` time,
	`total` decimal(10,2),
	`note` varchar(1000),
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `form297_personnel_entry_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `notifications` (
	`id` int AUTO_INCREMENT NOT NULL,
	`entity_type` varchar(100) NOT NULL,
	`entity_id` varchar(64) NOT NULL,
	`type` varchar(100) NOT NULL,
	`recipient_id` int NOT NULL,
	`sender_id` int,
	`title` varchar(255),
	`message` text,
	`payload` json,
	`status` enum('pending','sent','failed') NOT NULL DEFAULT 'pending',
	`read_at` timestamp,
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `notifications_id` PRIMARY KEY(`id`)
);
--> statement-breakpoint
CREATE TABLE `role` (
	`id` int AUTO_INCREMENT NOT NULL,
	`name` varchar(255) NOT NULL,
	`description` varchar(255),
	`is_active` boolean NOT NULL DEFAULT true,
	`is_super_admin` boolean NOT NULL DEFAULT false,
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `role_id` PRIMARY KEY(`id`),
	CONSTRAINT `role_name_unique` UNIQUE(`name`)
);
--> statement-breakpoint
CREATE TABLE `user` (
	`id` int AUTO_INCREMENT NOT NULL,
	`name` varchar(255) NOT NULL,
	`phone` varchar(20) NOT NULL,
	`email` varchar(255) NOT NULL,
	`password` varchar(255) NOT NULL,
	`role_id` int,
	`created_at` timestamp NOT NULL DEFAULT (now()),
	`updated_at` timestamp NOT NULL DEFAULT (now()) ON UPDATE CURRENT_TIMESTAMP,
	CONSTRAINT `user_id` PRIMARY KEY(`id`),
	CONSTRAINT `user_phone_unique` UNIQUE(`phone`),
	CONSTRAINT `user_email_unique` UNIQUE(`email`)
);
--> statement-breakpoint
ALTER TABLE `form261_report` ADD CONSTRAINT `form261_report_form_id_all_forms_id_fk` FOREIGN KEY (`form_id`) REFERENCES `all_forms`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form261_report` ADD CONSTRAINT `form261_report_created_by_user_id_fk` FOREIGN KEY (`created_by`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form261_report` ADD CONSTRAINT `form261_report_updated_by_user_id_fk` FOREIGN KEY (`updated_by`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form261_time_entry` ADD CONSTRAINT `form261_time_entry_report_id_form261_report_id_fk` FOREIGN KEY (`report_id`) REFERENCES `form261_report`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form261_time_entry` ADD CONSTRAINT `form261_time_entry_employee_user_id_user_id_fk` FOREIGN KEY (`employee_user_id`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form268_report` ADD CONSTRAINT `form268_report_form_id_all_forms_id_fk` FOREIGN KEY (`form_id`) REFERENCES `all_forms`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form268_report` ADD CONSTRAINT `form268_report_created_by_user_id_fk` FOREIGN KEY (`created_by`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form268_report` ADD CONSTRAINT `form268_report_updated_by_user_id_fk` FOREIGN KEY (`updated_by`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form268_rate_entry` ADD CONSTRAINT `form268_rate_entry_report_id_form268_report_id_fk` FOREIGN KEY (`report_id`) REFERENCES `form268_report`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form288_report` ADD CONSTRAINT `form288_report_form_id_all_forms_id_fk` FOREIGN KEY (`form_id`) REFERENCES `all_forms`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form288_report` ADD CONSTRAINT `form288_report_created_by_user_id_fk` FOREIGN KEY (`created_by`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form288_report` ADD CONSTRAINT `form288_report_updated_by_user_id_fk` FOREIGN KEY (`updated_by`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form288_employee` ADD CONSTRAINT `form288_employee_report_id_form288_report_id_fk` FOREIGN KEY (`report_id`) REFERENCES `form288_report`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form288_employee` ADD CONSTRAINT `form288_employee_employee_user_id_user_id_fk` FOREIGN KEY (`employee_user_id`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form288_commissary_entry` ADD CONSTRAINT `form288_commissary_entry_report_id_form288_report_id_fk` FOREIGN KEY (`report_id`) REFERENCES `form288_report`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form288_time_entry` ADD CONSTRAINT `form288_time_entry_employee_id_form288_employee_id_fk` FOREIGN KEY (`employee_id`) REFERENCES `form288_employee`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form297_ticket` ADD CONSTRAINT `form297_ticket_form_id_all_forms_id_fk` FOREIGN KEY (`form_id`) REFERENCES `all_forms`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form297_ticket` ADD CONSTRAINT `form297_ticket_created_by_user_id_fk` FOREIGN KEY (`created_by`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form297_ticket` ADD CONSTRAINT `form297_ticket_updated_by_user_id_fk` FOREIGN KEY (`updated_by`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form297_equipment_entry` ADD CONSTRAINT `form297_equipment_entry_ticket_id_form297_ticket_id_fk` FOREIGN KEY (`ticket_id`) REFERENCES `form297_ticket`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form297_personnel_entry` ADD CONSTRAINT `form297_personnel_entry_ticket_id_form297_ticket_id_fk` FOREIGN KEY (`ticket_id`) REFERENCES `form297_ticket`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `form297_personnel_entry` ADD CONSTRAINT `form297_personnel_entry_operator_user_id_user_id_fk` FOREIGN KEY (`operator_user_id`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `notifications` ADD CONSTRAINT `notifications_recipient_id_user_id_fk` FOREIGN KEY (`recipient_id`) REFERENCES `user`(`id`) ON DELETE cascade ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `notifications` ADD CONSTRAINT `notifications_sender_id_user_id_fk` FOREIGN KEY (`sender_id`) REFERENCES `user`(`id`) ON DELETE set null ON UPDATE no action;--> statement-breakpoint
ALTER TABLE `user` ADD CONSTRAINT `user_role_id_role_id_fk` FOREIGN KEY (`role_id`) REFERENCES `role`(`id`) ON DELETE set null ON UPDATE no action;