require('dotenv').config();

const { defineConfig } = require('drizzle-kit');




module.exports = defineConfig({
  out: './drizzle/migrations',
  schema: './src/db/schemas/**/*.js',
  dialect: 'mysql',
  dbCredentials: {
    user: process.env.DB_User,
    password: process.env.DB_Password,
    host: process.env.DB_Host,
    port: process.env.DB_Port,
    database: process.env.DB_Name,
    connectionLimit:5,
    charset: "utf8mb4", // <--- add this
  },
});
